/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.mss;

import ibm.nways.jdm.GraphicActionNavigate;
import ibm.nways.jdm.GraphicComponent;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicFlyOver;
import ibm.nways.jdm.GraphicHelp;
import ibm.nways.jdm.GraphicImage;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.HelpRef;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.JdmLayout;
import ibm.nways.jdm.Log;
import ibm.nways.jdm.NavInitialRow;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.RemoteStatus;
import ibm.nways.jdm.StatusProxy;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.modelgen.GenModel;
import java.awt.Point;
import java.io.Serializable;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class BladeGraphic {
    private GenModel mssModel;
    private GenModel baseBladeResetModel;
    private GenModel pcmciaBladeModel;
    private GenModel systemModel;
    private JdmBrowser mssJdmBrowser;
    private Vector modelList;
    private Vector remoteStatusList;
    private Vector proxyStatusList;
    private Vector pcmcia_Info = new Vector();
    private boolean ssBlade = false;
    private boolean loggingOK;
    protected static final String PropertiesFile = "properties/Mss.txt";
    private static final String layoutKey = "blade.layout.scheme";
    private static final String fractKey = "blade.layout.fractions";
    static final int startingX = 20;

    protected BladeGraphic(JdmBrowser jdmBrowser) {
        this.mssJdmBrowser = jdmBrowser;
        this.modelList = new Vector();
        this.remoteStatusList = new Vector();
        this.proxyStatusList = new Vector();
        this.loggingOK = this.checkLogging(this.mssJdmBrowser);
    }

    protected GraphicPanel getGraphicPanel() {
        GraphicContainer graphicContainer;
        block26: {
            String string;
            ModelInfo modelInfo;
            GraphicImage graphicImage;
            Object object;
            StatusProxy statusProxy;
            block25: {
                block24: {
                    Object object2;
                    Object object3;
                    Properties properties;
                    Serializable serializable;
                    graphicContainer = new GraphicContainer();
                    statusProxy = null;
                    this.loggingOK = this.checkLogging(this.mssJdmBrowser);
                    try {
                        serializable = new URL(this.mssJdmBrowser.getDocumentBase(), PropertiesFile);
                        if (this.loggingOK) {
                            System.out.println("DocumentBase = " + this.mssJdmBrowser.getDocumentBase());
                        }
                        properties = new Properties();
                        properties.load(((URL)serializable).openStream());
                    }
                    catch (Exception exception) {
                        if (this.loggingOK) {
                            System.out.println("Error getting Mss Properties: " + exception.getMessage());
                        }
                        properties = null;
                        exception.printStackTrace();
                    }
                    JdmLayout jdmLayout = (JdmLayout)this.mssJdmBrowser.getLayout();
                    if (properties != null) {
                        serializable = new Integer((String)((Hashtable)properties).get(layoutKey));
                        if (this.loggingOK) {
                            System.out.println("The layout scheme prpt = " + serializable);
                        }
                        int n = (Integer)serializable;
                        jdmLayout.setScheme(n);
                        object3 = (String)((Hashtable)properties).get(fractKey);
                        object2 = new StringTokenizer((String)object3);
                        object = new float[((StringTokenizer)object2).countTokens()];
                        boolean bl = true;
                        int n2 = 0;
                        while (n2 < ((float[])object).length && ((StringTokenizer)object2).hasMoreTokens()) {
                            String string2 = ((StringTokenizer)object2).nextToken();
                            try {
                                object[n2] = Float.valueOf(string2).floatValue();
                            }
                            catch (NumberFormatException numberFormatException) {
                                if (this.loggingOK) {
                                    System.out.println("Bad layout.fractions parm(" + numberFormatException.getMessage() + ")");
                                }
                                bl = false;
                            }
                            ++n2;
                        }
                        if (bl) {
                            jdmLayout.setFracts((float[])object);
                        }
                    } else {
                        int n = 1;
                        jdmLayout.setScheme(n);
                    }
                    this.getBladeInfo();
                    ResourceBundle resourceBundle = ResourceBundle.getBundle("ibm.nways.mss.Resources");
                    serializable = null;
                    graphicImage = !this.ssBlade ? new GraphicImage(this.mssJdmBrowser.imageFrom(this, "Mssblade.gif"), new Point(20, 0), 2, new GraphicActionNavigate(this.mssJdmBrowser, new NavigationDestination("ibm.nways.mib2.SystemInfoPanel", this.systemModel), (NavigationContext)((Object)serializable)), null) : new GraphicImage(this.mssJdmBrowser.imageFrom(this, "ssmssblade.gif"), new Point(20, 0), 2, new GraphicActionNavigate(this.mssJdmBrowser, new NavigationDestination("ibm.nways.mib2.SystemInfoPanel", this.systemModel), (NavigationContext)((Object)serializable)), null);
                    graphicContainer.add(graphicImage);
                    object3 = new GraphicHelp(this.mssJdmBrowser, new Point(0, 0), new HelpRef(this));
                    graphicContainer.add((GraphicComponent)object3);
                    graphicImage = !this.ssBlade ? new GraphicImage(this.mssJdmBrowser.imageFrom(this, "Rs232bld.gif"), new Point(97, 494), 0, new GraphicActionNavigate(this.mssJdmBrowser, null, null), null) : new GraphicImage(this.mssJdmBrowser.imageFrom(this, "Rs232bld.gif"), new Point(38, 484), 0, new GraphicActionNavigate(this.mssJdmBrowser, null, null), null);
                    object2 = resourceBundle.getString("Serial Port");
                    GraphicFlyOver graphicFlyOver = new GraphicFlyOver((String)object2);
                    graphicImage.setFlyOver(graphicFlyOver);
                    graphicContainer.add(graphicImage);
                    graphicImage = !this.ssBlade ? new GraphicImage(this.mssJdmBrowser.imageFrom(this, "single1.gif"), new Point(88, 445), 0, new GraphicActionNavigate(this.mssJdmBrowser, new NavigationDestination("ibm.nways.mss.ResetBladePanel", this.baseBladeResetModel), null), null) : new GraphicImage(this.mssJdmBrowser.imageFrom(this, "single1.gif"), new Point(43, 446), 0, new GraphicActionNavigate(this.mssJdmBrowser, new NavigationDestination("ibm.nways.mss.ResetBladePanel", this.baseBladeResetModel), null), null);
                    object2 = resourceBundle.getString("Reset");
                    graphicFlyOver = new GraphicFlyOver((String)object2);
                    graphicImage.setFlyOver(graphicFlyOver);
                    graphicContainer.add(graphicImage);
                    try {
                        this.pcmcia_Info = this.pcmciaBladeModel.getRestOfInfo("Config", "default", null, null);
                    }
                    catch (Exception exception) {
                        if (!this.loggingOK) break block24;
                        System.out.println("Could not get blade PCMCIA Model");
                    }
                }
                try {
                    modelInfo = (ModelInfo)this.pcmcia_Info.elementAt(1);
                    string = modelInfo.get("Config.Mss8260PCAdapType").toString();
                    if (this.loggingOK) {
                        System.out.println("Blade pcmcia slot #1 type=" + string);
                    }
                    object = this.pcmciaBladeModel.getStatusRefForRow(modelInfo);
                    this.remoteStatusList.addElement(object);
                    statusProxy = new StatusProxy((RemoteStatus)object);
                    this.proxyStatusList.addElement(statusProxy);
                    graphicImage = this.getPcmciaImage(string, 1, modelInfo);
                    if (graphicImage != null) {
                        if (this.loggingOK) {
                            System.out.println("Setting Status PCMCIA Blade #1");
                        }
                        graphicImage.setStatus(statusProxy);
                        graphicContainer.add(graphicImage);
                    }
                }
                catch (Exception exception) {
                    if (!this.loggingOK) break block25;
                    System.out.println("No Blade pcmcia Adapter in Slot #1");
                }
            }
            try {
                modelInfo = (ModelInfo)this.pcmcia_Info.elementAt(0);
                string = modelInfo.get("Config.Mss8260PCAdapType").toString();
                if (this.loggingOK) {
                    System.out.println("Blade pcmcia slot #2 type=" + string);
                }
                object = this.pcmciaBladeModel.getStatusRefForRow(modelInfo);
                this.remoteStatusList.addElement(object);
                statusProxy = new StatusProxy((RemoteStatus)object);
                this.proxyStatusList.addElement(statusProxy);
                graphicImage = this.getPcmciaImage(string, 2, modelInfo);
                if (graphicImage != null) {
                    if (this.loggingOK) {
                        System.out.println("Setting Status PCMCIA Blade #2");
                    }
                    graphicImage.setStatus(statusProxy);
                    graphicContainer.add(graphicImage);
                }
            }
            catch (Exception exception) {
                if (!this.loggingOK) break block26;
                System.out.println("No Blade pcmcia Adapter in Slot #2");
            }
        }
        GraphicPanel graphicPanel = new GraphicPanel(this.mssJdmBrowser, graphicContainer);
        return graphicPanel;
    }

    private void getBladeInfo() {
        block14: {
            block13: {
                block12: {
                    this.loggingOK = this.checkLogging(this.mssJdmBrowser);
                    if (this.pcmciaBladeModel == null) {
                        try {
                            this.pcmciaBladeModel = (GenModel)this.mssModel.getComponent("PcmciaBlade");
                            if (this.loggingOK) {
                                System.out.println("Got Graphic pcmcia Blade");
                            }
                        }
                        catch (Exception exception) {
                            if (!this.loggingOK) break block12;
                            System.out.println("Exception getting Graphic Blade");
                        }
                    }
                }
                if (this.baseBladeResetModel == null) {
                    try {
                        this.baseBladeResetModel = (GenModel)this.mssModel.getComponent("BaseBladeReset");
                        if (this.loggingOK) {
                            System.out.println("Got Graphic baseBlade Reset");
                        }
                    }
                    catch (Exception exception) {
                        if (!this.loggingOK) break block13;
                        System.out.println("Exception getting Graphic Blade Reset ");
                    }
                }
            }
            if (this.systemModel == null) {
                try {
                    this.systemModel = (GenModel)this.mssModel.getComponent("System");
                    if (this.loggingOK) {
                        System.out.println("Got Graphic system model");
                        return;
                    }
                }
                catch (Exception exception) {
                    if (!this.loggingOK) break block14;
                    System.out.println("Exception getting Graphic System Model");
                    return;
                }
            }
        }
    }

    private GraphicImage getPcmciaImage(String string, int n, ModelInfo modelInfo) {
        GraphicImage graphicImage;
        this.loggingOK = this.checkLogging(this.mssJdmBrowser);
        Integer n2 = new Integer(string);
        int n3 = n2;
        NavigationDestination navigationDestination = new NavigationDestination("ibm.nways.mss.eui.PcmciaAdapterBladePanel", this.pcmciaBladeModel);
        NavigationContext navigationContext = new NavigationContext();
        NavInitialRow.setInitialRow(navigationContext, modelInfo);
        GraphicActionNavigate graphicActionNavigate = new GraphicActionNavigate(this.mssJdmBrowser, navigationDestination, navigationContext);
        switch (n3) {
            case 2: {
                graphicImage = new HarddriveBladePCA(this.mssJdmBrowser);
                ((HarddriveBladePCA)graphicImage).setSlot(n, this.ssBlade);
                graphicImage.setAction(graphicActionNavigate);
                break;
            }
            case 3: {
                graphicImage = new ModemBladePCA(this.mssJdmBrowser);
                ((ModemBladePCA)graphicImage).setSlot(n, this.ssBlade);
                graphicImage.setAction(graphicActionNavigate);
                break;
            }
            case 5: {
                graphicImage = new FlashBladePCA(this.mssJdmBrowser);
                ((FlashBladePCA)graphicImage).setSlot(n, this.ssBlade);
                graphicImage.setAction(graphicActionNavigate);
                break;
            }
            case 1: {
                graphicImage = new UnknownBladePCA(this.mssJdmBrowser);
                ((UnknownBladePCA)graphicImage).setSlot(n, this.ssBlade);
                graphicImage.setAction(graphicActionNavigate);
                break;
            }
            default: {
                graphicImage = null;
                if (!this.loggingOK) break;
                System.out.println("Unexpected Pcmcia type =" + string);
            }
        }
        return graphicImage;
    }

    protected void setMssModel(GenModel genModel) {
        this.mssModel = genModel;
    }

    protected void setSSBlade(boolean bl) {
        this.ssBlade = bl;
    }

    public boolean checkLogging(JdmBrowser jdmBrowser) {
        if (jdmBrowser.getIsApplication()) {
            return Log.getLog().getLoggingState();
        }
        return false;
    }

    class HarddriveBladePCA
    extends GraphicImage {
        private JdmBrowser browser;
        private GraphicFlyOver flyOver;
        private GraphicActionNavigate graphicAction;
        private int slot;

        public HarddriveBladePCA(JdmBrowser jdmBrowser) {
            BladeGraphic.this = BladeGraphic.this;
            ResourceBundle resourceBundle = ResourceBundle.getBundle("ibm.nways.mss.Resources");
            this.setZOrder(0);
            this.setImage(jdmBrowser.imageFrom(this, "hdriveBld.gif"));
            String string = resourceBundle.getString("Harddrive");
            this.flyOver = new GraphicFlyOver(string);
            this.setFlyOver(this.flyOver);
        }

        public void setSlot(int n, boolean bl) {
            if (!bl) {
                if (n == 1) {
                    this.setLocation(new Point(92, 74));
                    return;
                }
                this.setLocation(new Point(92, 187));
                return;
            }
            this.setLocation(new Point(43, 72));
        }
    }

    class ModemBladePCA
    extends GraphicImage {
        private JdmBrowser browser;
        private GraphicFlyOver flyOver;
        private GraphicActionNavigate graphicAction;
        private int slot;

        public ModemBladePCA(JdmBrowser jdmBrowser) {
            BladeGraphic.this = BladeGraphic.this;
            ResourceBundle resourceBundle = ResourceBundle.getBundle("ibm.nways.mss.Resources");
            this.setZOrder(0);
            this.setImage(jdmBrowser.imageFrom(this, "modemBld.gif"));
            String string = resourceBundle.getString("Modem");
            this.flyOver = new GraphicFlyOver(string);
            this.setFlyOver(this.flyOver);
        }

        public void setSlot(int n, boolean bl) {
            if (!bl) {
                if (n == 1) {
                    this.setLocation(new Point(99, 74));
                    return;
                }
                this.setLocation(new Point(99, 187));
                return;
            }
            if (n == 1) {
                this.setLocation(new Point(42, 72));
                return;
            }
            this.setLocation(new Point(53, 72));
        }
    }

    class FlashBladePCA
    extends GraphicImage {
        private JdmBrowser browser;
        private GraphicFlyOver flyOver;
        private GraphicActionNavigate graphicAction;
        private int slot;

        public FlashBladePCA(JdmBrowser jdmBrowser) {
            BladeGraphic.this = BladeGraphic.this;
            ResourceBundle resourceBundle = ResourceBundle.getBundle("ibm.nways.mss.Resources");
            this.setZOrder(0);
            this.setImage(jdmBrowser.imageFrom(this, "flashBld.gif"));
            String string = resourceBundle.getString("Flash");
            this.flyOver = new GraphicFlyOver(string);
            this.setFlyOver(this.flyOver);
        }

        public void setSlot(int n, boolean bl) {
            if (!bl) {
                if (n == 1) {
                    this.setLocation(new Point(99, 74));
                    return;
                }
                this.setLocation(new Point(99, 187));
                return;
            }
            if (n == 1) {
                this.setLocation(new Point(42, 72));
                return;
            }
            this.setLocation(new Point(53, 72));
        }
    }

    class UnknownBladePCA
    extends GraphicImage {
        private JdmBrowser browser;
        private GraphicFlyOver flyOver;
        private int slot;

        public UnknownBladePCA(JdmBrowser jdmBrowser) {
            BladeGraphic.this = BladeGraphic.this;
            ResourceBundle resourceBundle = ResourceBundle.getBundle("ibm.nways.mss.Resources");
            this.setZOrder(0);
            this.setImage(jdmBrowser.imageFrom(this, "PcmciaBld.gif"));
            String string = resourceBundle.getString("UNKNOWN");
            this.flyOver = new GraphicFlyOver(string);
            this.setFlyOver(this.flyOver);
        }

        public void setSlot(int n, boolean bl) {
            if (!bl) {
                if (n == 1) {
                    this.setLocation(new Point(99, 74));
                    return;
                }
                this.setLocation(new Point(99, 187));
                return;
            }
            if (n == 1) {
                this.setLocation(new Point(42, 72));
                return;
            }
            this.setLocation(new Point(53, 72));
        }
    }
}

